package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReleaseStaticIpRequest(staticIpName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest = {
    import ReleaseStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest.builder().staticIpName(staticIpName: java.lang.String).build()
  }
  def asReadOnly: ReleaseStaticIpRequest.ReadOnly = ReleaseStaticIpRequest.wrap(buildAwsValue())
}
object ReleaseStaticIpRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReleaseStaticIpRequest = ReleaseStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: primitives.ResourceName
    def staticIpName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest) extends ReleaseStaticIpRequest.ReadOnly { override def staticIpNameValue: primitives.ResourceName = impl.staticIpName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ReleaseStaticIpRequest): ReadOnly = new Wrapper(impl)
}