package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabaseParameter(allowedValues: scala.Option[String] = None, applyMethod: scala.Option[String] = None, applyType: scala.Option[String] = None, dataType: scala.Option[String] = None, description: scala.Option[String] = None, isModifiable: scala.Option[Boolean] = None, parameterName: scala.Option[String] = None, parameterValue: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter = {
    import RelationalDatabaseParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter.builder().optionallyWith(allowedValues.map(value => value: java.lang.String))(_.allowedValues).optionallyWith(applyMethod.map(value => value: java.lang.String))(_.applyMethod).optionallyWith(applyType.map(value => value: java.lang.String))(_.applyType).optionallyWith(dataType.map(value => value: java.lang.String))(_.dataType).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(_.isModifiable).optionallyWith(parameterName.map(value => value: java.lang.String))(_.parameterName).optionallyWith(parameterValue.map(value => value: java.lang.String))(_.parameterValue).build()
  }
  def asReadOnly: RelationalDatabaseParameter.ReadOnly = RelationalDatabaseParameter.wrap(buildAwsValue())
}
object RelationalDatabaseParameter {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabaseParameter = RelationalDatabaseParameter(allowedValuesValue.map(value => value), applyMethodValue.map(value => value), applyTypeValue.map(value => value), dataTypeValue.map(value => value), descriptionValue.map(value => value), isModifiableValue.map(value => value), parameterNameValue.map(value => value), parameterValueValue.map(value => value))
    def allowedValuesValue: scala.Option[String]
    def applyMethodValue: scala.Option[String]
    def applyTypeValue: scala.Option[String]
    def dataTypeValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def isModifiableValue: scala.Option[Boolean]
    def parameterNameValue: scala.Option[String]
    def parameterValueValue: scala.Option[String]
    def allowedValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedValues", allowedValuesValue)
    def applyMethod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyMethod", applyMethodValue)
    def applyType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyType", applyTypeValue)
    def dataType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dataType", dataTypeValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def isModifiable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isModifiable", isModifiableValue)
    def parameterName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameterName", parameterNameValue)
    def parameterValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameterValue", parameterValueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter) extends RelationalDatabaseParameter.ReadOnly {
    override def allowedValuesValue: scala.Option[String] = scala.Option(impl.allowedValues()).map(value => value: String)
    override def applyMethodValue: scala.Option[String] = scala.Option(impl.applyMethod()).map(value => value: String)
    override def applyTypeValue: scala.Option[String] = scala.Option(impl.applyType()).map(value => value: String)
    override def dataTypeValue: scala.Option[String] = scala.Option(impl.dataType()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def isModifiableValue: scala.Option[Boolean] = scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override def parameterNameValue: scala.Option[String] = scala.Option(impl.parameterName()).map(value => value: String)
    override def parameterValueValue: scala.Option[String] = scala.Option(impl.parameterValue()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter): ReadOnly = new Wrapper(impl)
}