package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PutInstancePublicPortsRequest(portInfos: Iterable[PortInfo], instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest = {
    import PutInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest.builder().portInfos(portInfos.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: PutInstancePublicPortsRequest.ReadOnly = PutInstancePublicPortsRequest.wrap(buildAwsValue())
}
object PutInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PutInstancePublicPortsRequest = PutInstancePublicPortsRequest(portInfosValue.map { item => 
      item.editable
    }, instanceNameValue)
    def portInfosValue: List[PortInfo.ReadOnly]
    def instanceNameValue: primitives.ResourceName
    def portInfos: ZIO[Any, Nothing, List[PortInfo.ReadOnly]] = ZIO.succeed(portInfosValue)
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest) extends PutInstancePublicPortsRequest.ReadOnly {
    override def portInfosValue: List[PortInfo.ReadOnly] = impl.portInfos().asScala.map { item => 
      PortInfo.wrap(item)
    }.toList
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsRequest): ReadOnly = new Wrapper(impl)
}