package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PendingModifiedRelationalDatabaseValues(masterUserPassword: scala.Option[String] = None, engineVersion: scala.Option[String] = None, backupRetentionEnabled: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues = {
    import PendingModifiedRelationalDatabaseValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues.builder().optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(backupRetentionEnabled.map(value => value: java.lang.Boolean))(_.backupRetentionEnabled).build()
  }
  def asReadOnly: PendingModifiedRelationalDatabaseValues.ReadOnly = PendingModifiedRelationalDatabaseValues.wrap(buildAwsValue())
}
object PendingModifiedRelationalDatabaseValues {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PendingModifiedRelationalDatabaseValues = PendingModifiedRelationalDatabaseValues(masterUserPasswordValue.map(value => value), engineVersionValue.map(value => value), backupRetentionEnabledValue.map(value => value))
    def masterUserPasswordValue: scala.Option[String]
    def engineVersionValue: scala.Option[String]
    def backupRetentionEnabledValue: scala.Option[Boolean]
    def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def backupRetentionEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionEnabled", backupRetentionEnabledValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues) extends PendingModifiedRelationalDatabaseValues.ReadOnly {
    override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
    override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    override def backupRetentionEnabledValue: scala.Option[Boolean] = scala.Option(impl.backupRetentionEnabled()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.PendingModifiedRelationalDatabaseValues): ReadOnly = new Wrapper(impl)
}