package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PendingMaintenanceAction(action: scala.Option[primitives.NonEmptyString] = None, description: scala.Option[primitives.NonEmptyString] = None, currentApplyDate: scala.Option[primitives.IsoDate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction = {
    import PendingMaintenanceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction.builder().optionallyWith(action.map(value => value: java.lang.String))(_.action).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(currentApplyDate.map(value => value: java.time.Instant))(_.currentApplyDate).build()
  }
  def asReadOnly: PendingMaintenanceAction.ReadOnly = PendingMaintenanceAction.wrap(buildAwsValue())
}
object PendingMaintenanceAction {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PendingMaintenanceAction = PendingMaintenanceAction(actionValue.map(value => value), descriptionValue.map(value => value), currentApplyDateValue.map(value => value))
    def actionValue: scala.Option[primitives.NonEmptyString]
    def descriptionValue: scala.Option[primitives.NonEmptyString]
    def currentApplyDateValue: scala.Option[primitives.IsoDate]
    def action: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("action", actionValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def currentApplyDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentApplyDate", currentApplyDateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction) extends PendingMaintenanceAction.ReadOnly {
    override def actionValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.action()).map(value => value: primitives.NonEmptyString)
    override def descriptionValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.description()).map(value => value: primitives.NonEmptyString)
    override def currentApplyDateValue: scala.Option[primitives.IsoDate] = scala.Option(impl.currentApplyDate()).map(value => value: primitives.IsoDate)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.PendingMaintenanceAction): ReadOnly = new Wrapper(impl)
}