package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LoadBalancerTlsCertificateDomainValidationOption(domainName: scala.Option[primitives.DomainName] = None, validationStatus: scala.Option[LoadBalancerTlsCertificateDomainStatus] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption = {
    import LoadBalancerTlsCertificateDomainValidationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.builder().optionallyWith(domainName.map(value => value: java.lang.String))(_.domainName).optionallyWith(validationStatus.map(value => value.unwrap))(_.validationStatus).build()
  }
  def asReadOnly: LoadBalancerTlsCertificateDomainValidationOption.ReadOnly = LoadBalancerTlsCertificateDomainValidationOption.wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDomainValidationOption {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LoadBalancerTlsCertificateDomainValidationOption = LoadBalancerTlsCertificateDomainValidationOption(domainNameValue.map(value => value), validationStatusValue.map(value => value))
    def domainNameValue: scala.Option[primitives.DomainName]
    def validationStatusValue: scala.Option[LoadBalancerTlsCertificateDomainStatus]
    def domainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DomainName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainName", domainNameValue)
    def validationStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerTlsCertificateDomainStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validationStatus", validationStatusValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption) extends LoadBalancerTlsCertificateDomainValidationOption.ReadOnly {
    override def domainNameValue: scala.Option[primitives.DomainName] = scala.Option(impl.domainName()).map(value => value: primitives.DomainName)
    override def validationStatusValue: scala.Option[LoadBalancerTlsCertificateDomainStatus] = scala.Option(impl.validationStatus()).map(value => LoadBalancerTlsCertificateDomainStatus.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption): ReadOnly = new Wrapper(impl)
}