package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LoadBalancer(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, dnsName: scala.Option[primitives.NonEmptyString] = None, state: scala.Option[LoadBalancerState] = None, protocol: scala.Option[LoadBalancerProtocol] = None, publicPorts: scala.Option[Iterable[primitives.Port]] = None, healthCheckPath: scala.Option[primitives.NonEmptyString] = None, instancePort: scala.Option[primitives.Integer] = None, instanceHealthSummary: scala.Option[Iterable[InstanceHealthSummary]] = None, tlsCertificateSummaries: scala.Option[Iterable[LoadBalancerTlsCertificateSummary]] = None, configurationOptions: scala.Option[Map[LoadBalancerAttributeName, String]] = None, ipAddressType: scala.Option[IpAddressType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LoadBalancer = {
    import LoadBalancer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancer.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(protocol.map(value => value.unwrap))(_.protocol).optionallyWith(publicPorts.map(value => value.map { item => 
      item: java.lang.Integer
    }.asJavaCollection))(_.publicPorts).optionallyWith(healthCheckPath.map(value => value: java.lang.String))(_.healthCheckPath).optionallyWith(instancePort.map(value => value: java.lang.Integer))(_.instancePort).optionallyWith(instanceHealthSummary.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.instanceHealthSummary).optionallyWith(tlsCertificateSummaries.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tlsCertificateSummaries).optionallyWith(configurationOptions.map(value => value.map({
      case (key, value) =>
        key.unwrap.toString -> (value: java.lang.String)
    }).asJava))(_.configurationOptionsWithStrings).optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType).build()
  }
  def asReadOnly: LoadBalancer.ReadOnly = LoadBalancer.wrap(buildAwsValue())
}
object LoadBalancer {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LoadBalancer] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LoadBalancer = LoadBalancer(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), dnsNameValue.map(value => value), stateValue.map(value => value), protocolValue.map(value => value), publicPortsValue.map(value => value), healthCheckPathValue.map(value => value), instancePortValue.map(value => value), instanceHealthSummaryValue.map(value => value.map { item => 
      item.editable
    }), tlsCertificateSummariesValue.map(value => value.map { item => 
      item.editable
    }), configurationOptionsValue.map(value => value), ipAddressTypeValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def dnsNameValue: scala.Option[primitives.NonEmptyString]
    def stateValue: scala.Option[LoadBalancerState]
    def protocolValue: scala.Option[LoadBalancerProtocol]
    def publicPortsValue: scala.Option[List[primitives.Port]]
    def healthCheckPathValue: scala.Option[primitives.NonEmptyString]
    def instancePortValue: scala.Option[primitives.Integer]
    def instanceHealthSummaryValue: scala.Option[List[InstanceHealthSummary.ReadOnly]]
    def tlsCertificateSummariesValue: scala.Option[List[LoadBalancerTlsCertificateSummary.ReadOnly]]
    def configurationOptionsValue: scala.Option[Map[LoadBalancerAttributeName, String]]
    def ipAddressTypeValue: scala.Option[IpAddressType]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def dnsName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dnsName", dnsNameValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def protocol: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerProtocol] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocol", protocolValue)
    def publicPorts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Port]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicPorts", publicPortsValue)
    def healthCheckPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("healthCheckPath", healthCheckPathValue)
    def instancePort: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instancePort", instancePortValue)
    def instanceHealthSummary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InstanceHealthSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceHealthSummary", instanceHealthSummaryValue)
    def tlsCertificateSummaries: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LoadBalancerTlsCertificateSummary.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tlsCertificateSummaries", tlsCertificateSummariesValue)
    def configurationOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[LoadBalancerAttributeName, String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("configurationOptions", configurationOptionsValue)
    def ipAddressType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IpAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer) extends LoadBalancer.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def dnsNameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.dnsName()).map(value => value: primitives.NonEmptyString)
    override def stateValue: scala.Option[LoadBalancerState] = scala.Option(impl.state()).map(value => LoadBalancerState.wrap(value))
    override def protocolValue: scala.Option[LoadBalancerProtocol] = scala.Option(impl.protocol()).map(value => LoadBalancerProtocol.wrap(value))
    override def publicPortsValue: scala.Option[List[primitives.Port]] = scala.Option(impl.publicPorts()).map(value => value.asScala.map { item => 
      item: primitives.Port
    }.toList)
    override def healthCheckPathValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.healthCheckPath()).map(value => value: primitives.NonEmptyString)
    override def instancePortValue: scala.Option[primitives.Integer] = scala.Option(impl.instancePort()).map(value => value: primitives.Integer)
    override def instanceHealthSummaryValue: scala.Option[List[InstanceHealthSummary.ReadOnly]] = scala.Option(impl.instanceHealthSummary()).map(value => value.asScala.map { item => 
      InstanceHealthSummary.wrap(item)
    }.toList)
    override def tlsCertificateSummariesValue: scala.Option[List[LoadBalancerTlsCertificateSummary.ReadOnly]] = scala.Option(impl.tlsCertificateSummaries()).map(value => value.asScala.map { item => 
      LoadBalancerTlsCertificateSummary.wrap(item)
    }.toList)
    override def configurationOptionsValue: scala.Option[Map[LoadBalancerAttributeName, String]] = scala.Option(impl.configurationOptions()).map(value => value.asScala.map({
      case (key, value) =>
        LoadBalancerAttributeName.wrap(key) -> (value: String)
    }).toMap)
    override def ipAddressTypeValue: scala.Option[IpAddressType] = scala.Option(impl.ipAddressType()).map(value => IpAddressType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancer): ReadOnly = new Wrapper(impl)
}