package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LightsailDistribution(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, alternativeDomainNames: scala.Option[Iterable[String]] = None, status: scala.Option[String] = None, isEnabled: scala.Option[Boolean] = None, domainName: scala.Option[String] = None, bundleId: scala.Option[String] = None, certificateName: scala.Option[primitives.ResourceName] = None, origin: scala.Option[Origin] = None, originPublicDNS: scala.Option[String] = None, defaultCacheBehavior: scala.Option[CacheBehavior] = None, cacheBehaviorSettings: scala.Option[CacheSettings] = None, cacheBehaviors: scala.Option[Iterable[CacheBehaviorPerPath]] = None, ableToUpdateBundle: scala.Option[Boolean] = None, ipAddressType: scala.Option[IpAddressType] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LightsailDistribution = {
    import LightsailDistribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LightsailDistribution.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(alternativeDomainNames.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.alternativeDomainNames).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(isEnabled.map(value => value: java.lang.Boolean))(_.isEnabled).optionallyWith(domainName.map(value => value: java.lang.String))(_.domainName).optionallyWith(bundleId.map(value => value: java.lang.String))(_.bundleId).optionallyWith(certificateName.map(value => value: java.lang.String))(_.certificateName).optionallyWith(origin.map(value => value.buildAwsValue()))(_.origin).optionallyWith(originPublicDNS.map(value => value: java.lang.String))(_.originPublicDNS).optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(_.defaultCacheBehavior).optionallyWith(cacheBehaviorSettings.map(value => value.buildAwsValue()))(_.cacheBehaviorSettings).optionallyWith(cacheBehaviors.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.cacheBehaviors).optionallyWith(ableToUpdateBundle.map(value => value: java.lang.Boolean))(_.ableToUpdateBundle).optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: LightsailDistribution.ReadOnly = LightsailDistribution.wrap(buildAwsValue())
}
object LightsailDistribution {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LightsailDistribution] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LightsailDistribution = LightsailDistribution(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), alternativeDomainNamesValue.map(value => value), statusValue.map(value => value), isEnabledValue.map(value => value), domainNameValue.map(value => value), bundleIdValue.map(value => value), certificateNameValue.map(value => value), originValue.map(value => value.editable), originPublicDNSValue.map(value => value), defaultCacheBehaviorValue.map(value => value.editable), cacheBehaviorSettingsValue.map(value => value.editable), cacheBehaviorsValue.map(value => value.map { item => 
      item.editable
    }), ableToUpdateBundleValue.map(value => value), ipAddressTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def alternativeDomainNamesValue: scala.Option[List[String]]
    def statusValue: scala.Option[String]
    def isEnabledValue: scala.Option[Boolean]
    def domainNameValue: scala.Option[String]
    def bundleIdValue: scala.Option[String]
    def certificateNameValue: scala.Option[primitives.ResourceName]
    def originValue: scala.Option[Origin.ReadOnly]
    def originPublicDNSValue: scala.Option[String]
    def defaultCacheBehaviorValue: scala.Option[CacheBehavior.ReadOnly]
    def cacheBehaviorSettingsValue: scala.Option[CacheSettings.ReadOnly]
    def cacheBehaviorsValue: scala.Option[List[CacheBehaviorPerPath.ReadOnly]]
    def ableToUpdateBundleValue: scala.Option[Boolean]
    def ipAddressTypeValue: scala.Option[IpAddressType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def alternativeDomainNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("alternativeDomainNames", alternativeDomainNamesValue)
    def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    def isEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isEnabled", isEnabledValue)
    def domainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainName", domainNameValue)
    def bundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def certificateName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateName", certificateNameValue)
    def origin: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Origin.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("origin", originValue)
    def originPublicDNS: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("originPublicDNS", originPublicDNSValue)
    def defaultCacheBehavior: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CacheBehavior.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultCacheBehavior", defaultCacheBehaviorValue)
    def cacheBehaviorSettings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CacheSettings.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cacheBehaviorSettings", cacheBehaviorSettingsValue)
    def cacheBehaviors: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CacheBehaviorPerPath.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviorsValue)
    def ableToUpdateBundle: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundleValue)
    def ipAddressType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IpAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution) extends LightsailDistribution.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def alternativeDomainNamesValue: scala.Option[List[String]] = scala.Option(impl.alternativeDomainNames()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    override def isEnabledValue: scala.Option[Boolean] = scala.Option(impl.isEnabled()).map(value => value: Boolean)
    override def domainNameValue: scala.Option[String] = scala.Option(impl.domainName()).map(value => value: String)
    override def bundleIdValue: scala.Option[String] = scala.Option(impl.bundleId()).map(value => value: String)
    override def certificateNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.certificateName()).map(value => value: primitives.ResourceName)
    override def originValue: scala.Option[Origin.ReadOnly] = scala.Option(impl.origin()).map(value => Origin.wrap(value))
    override def originPublicDNSValue: scala.Option[String] = scala.Option(impl.originPublicDNS()).map(value => value: String)
    override def defaultCacheBehaviorValue: scala.Option[CacheBehavior.ReadOnly] = scala.Option(impl.defaultCacheBehavior()).map(value => CacheBehavior.wrap(value))
    override def cacheBehaviorSettingsValue: scala.Option[CacheSettings.ReadOnly] = scala.Option(impl.cacheBehaviorSettings()).map(value => CacheSettings.wrap(value))
    override def cacheBehaviorsValue: scala.Option[List[CacheBehaviorPerPath.ReadOnly]] = scala.Option(impl.cacheBehaviors()).map(value => value.asScala.map { item => 
      CacheBehaviorPerPath.wrap(item)
    }.toList)
    override def ableToUpdateBundleValue: scala.Option[Boolean] = scala.Option(impl.ableToUpdateBundle()).map(value => value: Boolean)
    override def ipAddressTypeValue: scala.Option[IpAddressType] = scala.Option(impl.ipAddressType()).map(value => IpAddressType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution): ReadOnly = new Wrapper(impl)
}