package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstancePortInfo(fromPort: scala.Option[primitives.Port] = None, toPort: scala.Option[primitives.Port] = None, protocol: scala.Option[NetworkProtocol] = None, accessFrom: scala.Option[String] = None, accessType: scala.Option[PortAccessType] = None, commonName: scala.Option[String] = None, accessDirection: scala.Option[AccessDirection] = None, cidrs: scala.Option[Iterable[String]] = None, ipv6Cidrs: scala.Option[Iterable[String]] = None, cidrListAliases: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstancePortInfo = {
    import InstancePortInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstancePortInfo.builder().optionallyWith(fromPort.map(value => value: java.lang.Integer))(_.fromPort).optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort).optionallyWith(protocol.map(value => value.unwrap))(_.protocol).optionallyWith(accessFrom.map(value => value: java.lang.String))(_.accessFrom).optionallyWith(accessType.map(value => value.unwrap))(_.accessType).optionallyWith(commonName.map(value => value: java.lang.String))(_.commonName).optionallyWith(accessDirection.map(value => value.unwrap))(_.accessDirection).optionallyWith(cidrs.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.cidrs).optionallyWith(ipv6Cidrs.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.ipv6Cidrs).optionallyWith(cidrListAliases.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.cidrListAliases).build()
  }
  def asReadOnly: InstancePortInfo.ReadOnly = InstancePortInfo.wrap(buildAwsValue())
}
object InstancePortInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstancePortInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstancePortInfo = InstancePortInfo(fromPortValue.map(value => value), toPortValue.map(value => value), protocolValue.map(value => value), accessFromValue.map(value => value), accessTypeValue.map(value => value), commonNameValue.map(value => value), accessDirectionValue.map(value => value), cidrsValue.map(value => value), ipv6CidrsValue.map(value => value), cidrListAliasesValue.map(value => value))
    def fromPortValue: scala.Option[primitives.Port]
    def toPortValue: scala.Option[primitives.Port]
    def protocolValue: scala.Option[NetworkProtocol]
    def accessFromValue: scala.Option[String]
    def accessTypeValue: scala.Option[PortAccessType]
    def commonNameValue: scala.Option[String]
    def accessDirectionValue: scala.Option[AccessDirection]
    def cidrsValue: scala.Option[List[String]]
    def ipv6CidrsValue: scala.Option[List[String]]
    def cidrListAliasesValue: scala.Option[List[String]]
    def fromPort: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Port] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromPort", fromPortValue)
    def toPort: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Port] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("toPort", toPortValue)
    def protocol: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, NetworkProtocol] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocol", protocolValue)
    def accessFrom: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessFrom", accessFromValue)
    def accessType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PortAccessType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessType", accessTypeValue)
    def commonName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("commonName", commonNameValue)
    def accessDirection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccessDirection] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessDirection", accessDirectionValue)
    def cidrs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cidrs", cidrsValue)
    def ipv6Cidrs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipv6Cidrs", ipv6CidrsValue)
    def cidrListAliases: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cidrListAliases", cidrListAliasesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo) extends InstancePortInfo.ReadOnly {
    override def fromPortValue: scala.Option[primitives.Port] = scala.Option(impl.fromPort()).map(value => value: primitives.Port)
    override def toPortValue: scala.Option[primitives.Port] = scala.Option(impl.toPort()).map(value => value: primitives.Port)
    override def protocolValue: scala.Option[NetworkProtocol] = scala.Option(impl.protocol()).map(value => NetworkProtocol.wrap(value))
    override def accessFromValue: scala.Option[String] = scala.Option(impl.accessFrom()).map(value => value: String)
    override def accessTypeValue: scala.Option[PortAccessType] = scala.Option(impl.accessType()).map(value => PortAccessType.wrap(value))
    override def commonNameValue: scala.Option[String] = scala.Option(impl.commonName()).map(value => value: String)
    override def accessDirectionValue: scala.Option[AccessDirection] = scala.Option(impl.accessDirection()).map(value => AccessDirection.wrap(value))
    override def cidrsValue: scala.Option[List[String]] = scala.Option(impl.cidrs()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def ipv6CidrsValue: scala.Option[List[String]] = scala.Option(impl.ipv6Cidrs()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
    override def cidrListAliasesValue: scala.Option[List[String]] = scala.Option(impl.cidrListAliases()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo): ReadOnly = new Wrapper(impl)
}