package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseEventsResponse(relationalDatabaseEvents: scala.Option[Iterable[RelationalDatabaseEvent]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse = {
    import GetRelationalDatabaseEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse.builder().optionallyWith(relationalDatabaseEvents.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.relationalDatabaseEvents).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseEventsResponse.ReadOnly = GetRelationalDatabaseEventsResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseEventsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseEventsResponse = GetRelationalDatabaseEventsResponse(relationalDatabaseEventsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def relationalDatabaseEventsValue: scala.Option[List[RelationalDatabaseEvent.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def relationalDatabaseEvents: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RelationalDatabaseEvent.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseEvents", relationalDatabaseEventsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse) extends GetRelationalDatabaseEventsResponse.ReadOnly {
    override def relationalDatabaseEventsValue: scala.Option[List[RelationalDatabaseEvent.ReadOnly]] = scala.Option(impl.relationalDatabaseEvents()).map(value => value.asScala.map { item => 
      RelationalDatabaseEvent.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsResponse): ReadOnly = new Wrapper(impl)
}