package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLoadBalancersResponse(loadBalancers: scala.Option[Iterable[LoadBalancer]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse = {
    import GetLoadBalancersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse.builder().optionallyWith(loadBalancers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.loadBalancers).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetLoadBalancersResponse.ReadOnly = GetLoadBalancersResponse.wrap(buildAwsValue())
}
object GetLoadBalancersResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLoadBalancersResponse = GetLoadBalancersResponse(loadBalancersValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def loadBalancersValue: scala.Option[List[LoadBalancer.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def loadBalancers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LoadBalancer.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("loadBalancers", loadBalancersValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse) extends GetLoadBalancersResponse.ReadOnly {
    override def loadBalancersValue: scala.Option[List[LoadBalancer.ReadOnly]] = scala.Option(impl.loadBalancers()).map(value => value.asScala.map { item => 
      LoadBalancer.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancersResponse): ReadOnly = new Wrapper(impl)
}