package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceAccessDetailsRequest(instanceName: primitives.ResourceName, protocol: scala.Option[InstanceAccessProtocol] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest = {
    import GetInstanceAccessDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest.builder().instanceName(instanceName: java.lang.String).optionallyWith(protocol.map(value => value.unwrap))(_.protocol).build()
  }
  def asReadOnly: GetInstanceAccessDetailsRequest.ReadOnly = GetInstanceAccessDetailsRequest.wrap(buildAwsValue())
}
object GetInstanceAccessDetailsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceAccessDetailsRequest = GetInstanceAccessDetailsRequest(instanceNameValue, protocolValue.map(value => value))
    def instanceNameValue: primitives.ResourceName
    def protocolValue: scala.Option[InstanceAccessProtocol]
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
    def protocol: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceAccessProtocol] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocol", protocolValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest) extends GetInstanceAccessDetailsRequest.ReadOnly {
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
    override def protocolValue: scala.Option[InstanceAccessProtocol] = scala.Option(impl.protocol()).map(value => InstanceAccessProtocol.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsRequest): ReadOnly = new Wrapper(impl)
}