package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDistributionsRequest(distributionName: scala.Option[primitives.ResourceName] = None, pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest = {
    import GetDistributionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest.builder().optionallyWith(distributionName.map(value => value: java.lang.String))(_.distributionName).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetDistributionsRequest.ReadOnly = GetDistributionsRequest.wrap(buildAwsValue())
}
object GetDistributionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDistributionsRequest = GetDistributionsRequest(distributionNameValue.map(value => value), pageTokenValue.map(value => value))
    def distributionNameValue: scala.Option[primitives.ResourceName]
    def pageTokenValue: scala.Option[String]
    def distributionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("distributionName", distributionNameValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest) extends GetDistributionsRequest.ReadOnly {
    override def distributionNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.distributionName()).map(value => value: primitives.ResourceName)
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsRequest): ReadOnly = new Wrapper(impl)
}