package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDiskResponse(disk: scala.Option[Disk] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDiskResponse = {
    import GetDiskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskResponse.builder().optionallyWith(disk.map(value => value.buildAwsValue()))(_.disk).build()
  }
  def asReadOnly: GetDiskResponse.ReadOnly = GetDiskResponse.wrap(buildAwsValue())
}
object GetDiskResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDiskResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDiskResponse = GetDiskResponse(diskValue.map(value => value.editable))
    def diskValue: scala.Option[Disk.ReadOnly]
    def disk: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Disk.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disk", diskValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDiskResponse) extends GetDiskResponse.ReadOnly { override def diskValue: scala.Option[Disk.ReadOnly] = scala.Option(impl.disk()).map(value => Disk.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDiskResponse): ReadOnly = new Wrapper(impl)
}