package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerServicePowersResponse(powers: scala.Option[Iterable[ContainerServicePower]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse = {
    import GetContainerServicePowersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse.builder().optionallyWith(powers.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.powers).build()
  }
  def asReadOnly: GetContainerServicePowersResponse.ReadOnly = GetContainerServicePowersResponse.wrap(buildAwsValue())
}
object GetContainerServicePowersResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerServicePowersResponse = GetContainerServicePowersResponse(powersValue.map(value => value.map { item => 
      item.editable
    }))
    def powersValue: scala.Option[List[ContainerServicePower.ReadOnly]]
    def powers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContainerServicePower.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("powers", powersValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse) extends GetContainerServicePowersResponse.ReadOnly {
    override def powersValue: scala.Option[List[ContainerServicePower.ReadOnly]] = scala.Option(impl.powers()).map(value => value.asScala.map { item => 
      ContainerServicePower.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicePowersResponse): ReadOnly = new Wrapper(impl)
}