package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerLogResponse(logEvents: scala.Option[Iterable[ContainerServiceLogEvent]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse = {
    import GetContainerLogResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse.builder().optionallyWith(logEvents.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.logEvents).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetContainerLogResponse.ReadOnly = GetContainerLogResponse.wrap(buildAwsValue())
}
object GetContainerLogResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerLogResponse = GetContainerLogResponse(logEventsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def logEventsValue: scala.Option[List[ContainerServiceLogEvent.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def logEvents: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContainerServiceLogEvent.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("logEvents", logEventsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse) extends GetContainerLogResponse.ReadOnly {
    override def logEventsValue: scala.Option[List[ContainerServiceLogEvent.ReadOnly]] = scala.Option(impl.logEvents()).map(value => value.asScala.map { item => 
      ContainerServiceLogEvent.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogResponse): ReadOnly = new Wrapper(impl)
}