package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerImagesRequest(serviceName: primitives.ContainerServiceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest = {
    import GetContainerImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest.builder().serviceName(serviceName: java.lang.String).build()
  }
  def asReadOnly: GetContainerImagesRequest.ReadOnly = GetContainerImagesRequest.wrap(buildAwsValue())
}
object GetContainerImagesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerImagesRequest = GetContainerImagesRequest(serviceNameValue)
    def serviceNameValue: primitives.ContainerServiceName
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest) extends GetContainerImagesRequest.ReadOnly { override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest): ReadOnly = new Wrapper(impl)
}