package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAutoSnapshotsRequest(resourceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest = {
    import GetAutoSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest.builder().resourceName(resourceName: java.lang.String).build()
  }
  def asReadOnly: GetAutoSnapshotsRequest.ReadOnly = GetAutoSnapshotsRequest.wrap(buildAwsValue())
}
object GetAutoSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAutoSnapshotsRequest = GetAutoSnapshotsRequest(resourceNameValue)
    def resourceNameValue: primitives.ResourceName
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest) extends GetAutoSnapshotsRequest.ReadOnly { override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetAutoSnapshotsRequest): ReadOnly = new Wrapper(impl)
}