package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Disk(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, addOns: scala.Option[Iterable[AddOn]] = None, sizeInGb: scala.Option[primitives.Integer] = None, isSystemDisk: scala.Option[Boolean] = None, iops: scala.Option[primitives.Integer] = None, path: scala.Option[String] = None, state: scala.Option[DiskState] = None, attachedTo: scala.Option[primitives.ResourceName] = None, isAttached: scala.Option[Boolean] = None, attachmentState: scala.Option[String] = None, gbInUse: scala.Option[primitives.Integer] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Disk = {
    import Disk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Disk.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(addOns.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.addOns).optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(_.sizeInGb).optionallyWith(isSystemDisk.map(value => value: java.lang.Boolean))(_.isSystemDisk).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(path.map(value => value: java.lang.String))(_.path).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(attachedTo.map(value => value: java.lang.String))(_.attachedTo).optionallyWith(isAttached.map(value => value: java.lang.Boolean))(_.isAttached).optionallyWith(attachmentState.map(value => value: java.lang.String))(_.attachmentState).optionallyWith(gbInUse.map(value => value: java.lang.Integer))(_.gbInUse).build()
  }
  def asReadOnly: Disk.ReadOnly = Disk.wrap(buildAwsValue())
}
object Disk {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Disk] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Disk = Disk(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), addOnsValue.map(value => value.map { item => 
      item.editable
    }), sizeInGbValue.map(value => value), isSystemDiskValue.map(value => value), iopsValue.map(value => value), pathValue.map(value => value), stateValue.map(value => value), attachedToValue.map(value => value), isAttachedValue.map(value => value), attachmentStateValue.map(value => value), gbInUseValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def addOnsValue: scala.Option[List[AddOn.ReadOnly]]
    def sizeInGbValue: scala.Option[primitives.Integer]
    def isSystemDiskValue: scala.Option[Boolean]
    def iopsValue: scala.Option[primitives.Integer]
    def pathValue: scala.Option[String]
    def stateValue: scala.Option[DiskState]
    def attachedToValue: scala.Option[primitives.ResourceName]
    def isAttachedValue: scala.Option[Boolean]
    def attachmentStateValue: scala.Option[String]
    def gbInUseValue: scala.Option[primitives.Integer]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AddOn.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addOns", addOnsValue)
    def sizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
    def isSystemDisk: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isSystemDisk", isSystemDiskValue)
    def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
    def path: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("path", pathValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DiskState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def attachedTo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attachedTo", attachedToValue)
    def isAttached: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isAttached", isAttachedValue)
    def attachmentState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attachmentState", attachmentStateValue)
    def gbInUse: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("gbInUse", gbInUseValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Disk) extends Disk.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def addOnsValue: scala.Option[List[AddOn.ReadOnly]] = scala.Option(impl.addOns()).map(value => value.asScala.map { item => 
      AddOn.wrap(item)
    }.toList)
    override def sizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.sizeInGb()).map(value => value: primitives.Integer)
    override def isSystemDiskValue: scala.Option[Boolean] = scala.Option(impl.isSystemDisk()).map(value => value: Boolean)
    override def iopsValue: scala.Option[primitives.Integer] = scala.Option(impl.iops()).map(value => value: primitives.Integer)
    override def pathValue: scala.Option[String] = scala.Option(impl.path()).map(value => value: String)
    override def stateValue: scala.Option[DiskState] = scala.Option(impl.state()).map(value => DiskState.wrap(value))
    override def attachedToValue: scala.Option[primitives.ResourceName] = scala.Option(impl.attachedTo()).map(value => value: primitives.ResourceName)
    override def isAttachedValue: scala.Option[Boolean] = scala.Option(impl.isAttached()).map(value => value: Boolean)
    override def attachmentStateValue: scala.Option[String] = scala.Option(impl.attachmentState()).map(value => value: String)
    override def gbInUseValue: scala.Option[primitives.Integer] = scala.Option(impl.gbInUse()).map(value => value: primitives.Integer)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Disk): ReadOnly = new Wrapper(impl)
}