package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteKnownHostKeysRequest(instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest = {
    import DeleteKnownHostKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest.builder().instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: DeleteKnownHostKeysRequest.ReadOnly = DeleteKnownHostKeysRequest.wrap(buildAwsValue())
}
object DeleteKnownHostKeysRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteKnownHostKeysRequest = DeleteKnownHostKeysRequest(instanceNameValue)
    def instanceNameValue: primitives.ResourceName
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest) extends DeleteKnownHostKeysRequest.ReadOnly { override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteKnownHostKeysRequest): ReadOnly = new Wrapper(impl)
}