package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateRelationalDatabaseRequest(relationalDatabaseName: primitives.ResourceName, availabilityZone: scala.Option[String] = None, relationalDatabaseBlueprintId: String, relationalDatabaseBundleId: String, masterDatabaseName: String, masterUsername: String, masterUserPassword: scala.Option[primitives.SensitiveString] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, publiclyAccessible: scala.Option[Boolean] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest = {
    import CreateRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).relationalDatabaseBlueprintId(relationalDatabaseBlueprintId: java.lang.String).relationalDatabaseBundleId(relationalDatabaseBundleId: java.lang.String).masterDatabaseName(masterDatabaseName: java.lang.String).masterUsername(masterUsername: java.lang.String).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateRelationalDatabaseRequest.ReadOnly = CreateRelationalDatabaseRequest.wrap(buildAwsValue())
}
object CreateRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateRelationalDatabaseRequest = CreateRelationalDatabaseRequest(relationalDatabaseNameValue, availabilityZoneValue.map(value => value), relationalDatabaseBlueprintIdValue, relationalDatabaseBundleIdValue, masterDatabaseNameValue, masterUsernameValue, masterUserPasswordValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), publiclyAccessibleValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def relationalDatabaseNameValue: primitives.ResourceName
    def availabilityZoneValue: scala.Option[String]
    def relationalDatabaseBlueprintIdValue: String
    def relationalDatabaseBundleIdValue: String
    def masterDatabaseNameValue: String
    def masterUsernameValue: String
    def masterUserPasswordValue: scala.Option[primitives.SensitiveString]
    def preferredBackupWindowValue: scala.Option[String]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def publiclyAccessibleValue: scala.Option[Boolean]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def relationalDatabaseBlueprintId: ZIO[Any, Nothing, String] = ZIO.succeed(relationalDatabaseBlueprintIdValue)
    def relationalDatabaseBundleId: ZIO[Any, Nothing, String] = ZIO.succeed(relationalDatabaseBundleIdValue)
    def masterDatabaseName: ZIO[Any, Nothing, String] = ZIO.succeed(masterDatabaseNameValue)
    def masterUsername: ZIO[Any, Nothing, String] = ZIO.succeed(masterUsernameValue)
    def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SensitiveString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest) extends CreateRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
    override def relationalDatabaseBlueprintIdValue: String = impl.relationalDatabaseBlueprintId(): String
    override def relationalDatabaseBundleIdValue: String = impl.relationalDatabaseBundleId(): String
    override def masterDatabaseNameValue: String = impl.masterDatabaseName(): String
    override def masterUsernameValue: String = impl.masterUsername(): String
    override def masterUserPasswordValue: scala.Option[primitives.SensitiveString] = scala.Option(impl.masterUserPassword()).map(value => value: primitives.SensitiveString)
    override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def publiclyAccessibleValue: scala.Option[Boolean] = scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseRequest): ReadOnly = new Wrapper(impl)
}