package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateRelationalDatabaseFromSnapshotRequest(relationalDatabaseName: primitives.ResourceName, availabilityZone: scala.Option[String] = None, publiclyAccessible: scala.Option[Boolean] = None, relationalDatabaseSnapshotName: scala.Option[primitives.ResourceName] = None, relationalDatabaseBundleId: scala.Option[String] = None, sourceRelationalDatabaseName: scala.Option[primitives.ResourceName] = None, restoreTime: scala.Option[primitives.IsoDate] = None, useLatestRestorableTime: scala.Option[Boolean] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest = {
    import CreateRelationalDatabaseFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(relationalDatabaseSnapshotName.map(value => value: java.lang.String))(_.relationalDatabaseSnapshotName).optionallyWith(relationalDatabaseBundleId.map(value => value: java.lang.String))(_.relationalDatabaseBundleId).optionallyWith(sourceRelationalDatabaseName.map(value => value: java.lang.String))(_.sourceRelationalDatabaseName).optionallyWith(restoreTime.map(value => value: java.time.Instant))(_.restoreTime).optionallyWith(useLatestRestorableTime.map(value => value: java.lang.Boolean))(_.useLatestRestorableTime).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateRelationalDatabaseFromSnapshotRequest.ReadOnly = CreateRelationalDatabaseFromSnapshotRequest.wrap(buildAwsValue())
}
object CreateRelationalDatabaseFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateRelationalDatabaseFromSnapshotRequest = CreateRelationalDatabaseFromSnapshotRequest(relationalDatabaseNameValue, availabilityZoneValue.map(value => value), publiclyAccessibleValue.map(value => value), relationalDatabaseSnapshotNameValue.map(value => value), relationalDatabaseBundleIdValue.map(value => value), sourceRelationalDatabaseNameValue.map(value => value), restoreTimeValue.map(value => value), useLatestRestorableTimeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def relationalDatabaseNameValue: primitives.ResourceName
    def availabilityZoneValue: scala.Option[String]
    def publiclyAccessibleValue: scala.Option[Boolean]
    def relationalDatabaseSnapshotNameValue: scala.Option[primitives.ResourceName]
    def relationalDatabaseBundleIdValue: scala.Option[String]
    def sourceRelationalDatabaseNameValue: scala.Option[primitives.ResourceName]
    def restoreTimeValue: scala.Option[primitives.IsoDate]
    def useLatestRestorableTimeValue: scala.Option[Boolean]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def relationalDatabaseSnapshotName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseSnapshotName", relationalDatabaseSnapshotNameValue)
    def relationalDatabaseBundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseBundleId", relationalDatabaseBundleIdValue)
    def sourceRelationalDatabaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceRelationalDatabaseName", sourceRelationalDatabaseNameValue)
    def restoreTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("restoreTime", restoreTimeValue)
    def useLatestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useLatestRestorableTime", useLatestRestorableTimeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest) extends CreateRelationalDatabaseFromSnapshotRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
    override def publiclyAccessibleValue: scala.Option[Boolean] = scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def relationalDatabaseSnapshotNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.relationalDatabaseSnapshotName()).map(value => value: primitives.ResourceName)
    override def relationalDatabaseBundleIdValue: scala.Option[String] = scala.Option(impl.relationalDatabaseBundleId()).map(value => value: String)
    override def sourceRelationalDatabaseNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.sourceRelationalDatabaseName()).map(value => value: primitives.ResourceName)
    override def restoreTimeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.restoreTime()).map(value => value: primitives.IsoDate)
    override def useLatestRestorableTimeValue: scala.Option[Boolean] = scala.Option(impl.useLatestRestorableTime()).map(value => value: Boolean)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseFromSnapshotRequest): ReadOnly = new Wrapper(impl)
}