package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateInstanceSnapshotRequest(instanceSnapshotName: primitives.ResourceName, instanceName: primitives.ResourceName, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest = {
    import CreateInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest.builder().instanceSnapshotName(instanceSnapshotName: java.lang.String).instanceName(instanceName: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateInstanceSnapshotRequest.ReadOnly = CreateInstanceSnapshotRequest.wrap(buildAwsValue())
}
object CreateInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateInstanceSnapshotRequest = CreateInstanceSnapshotRequest(instanceSnapshotNameValue, instanceNameValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def instanceSnapshotNameValue: primitives.ResourceName
    def instanceNameValue: primitives.ResourceName
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def instanceSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceSnapshotNameValue)
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest) extends CreateInstanceSnapshotRequest.ReadOnly {
    override def instanceSnapshotNameValue: primitives.ResourceName = impl.instanceSnapshotName(): primitives.ResourceName
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateInstanceSnapshotRequest): ReadOnly = new Wrapper(impl)
}