package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerServiceHealthCheckConfig(healthyThreshold: scala.Option[primitives.Integer] = None, unhealthyThreshold: scala.Option[primitives.Integer] = None, timeoutSeconds: scala.Option[primitives.Integer] = None, intervalSeconds: scala.Option[primitives.Integer] = None, path: scala.Option[String] = None, successCodes: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig = {
    import ContainerServiceHealthCheckConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig.builder().optionallyWith(healthyThreshold.map(value => value: java.lang.Integer))(_.healthyThreshold).optionallyWith(unhealthyThreshold.map(value => value: java.lang.Integer))(_.unhealthyThreshold).optionallyWith(timeoutSeconds.map(value => value: java.lang.Integer))(_.timeoutSeconds).optionallyWith(intervalSeconds.map(value => value: java.lang.Integer))(_.intervalSeconds).optionallyWith(path.map(value => value: java.lang.String))(_.path).optionallyWith(successCodes.map(value => value: java.lang.String))(_.successCodes).build()
  }
  def asReadOnly: ContainerServiceHealthCheckConfig.ReadOnly = ContainerServiceHealthCheckConfig.wrap(buildAwsValue())
}
object ContainerServiceHealthCheckConfig {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerServiceHealthCheckConfig = ContainerServiceHealthCheckConfig(healthyThresholdValue.map(value => value), unhealthyThresholdValue.map(value => value), timeoutSecondsValue.map(value => value), intervalSecondsValue.map(value => value), pathValue.map(value => value), successCodesValue.map(value => value))
    def healthyThresholdValue: scala.Option[primitives.Integer]
    def unhealthyThresholdValue: scala.Option[primitives.Integer]
    def timeoutSecondsValue: scala.Option[primitives.Integer]
    def intervalSecondsValue: scala.Option[primitives.Integer]
    def pathValue: scala.Option[String]
    def successCodesValue: scala.Option[String]
    def healthyThreshold: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("healthyThreshold", healthyThresholdValue)
    def unhealthyThreshold: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unhealthyThreshold", unhealthyThresholdValue)
    def timeoutSeconds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timeoutSeconds", timeoutSecondsValue)
    def intervalSeconds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("intervalSeconds", intervalSecondsValue)
    def path: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("path", pathValue)
    def successCodes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("successCodes", successCodesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig) extends ContainerServiceHealthCheckConfig.ReadOnly {
    override def healthyThresholdValue: scala.Option[primitives.Integer] = scala.Option(impl.healthyThreshold()).map(value => value: primitives.Integer)
    override def unhealthyThresholdValue: scala.Option[primitives.Integer] = scala.Option(impl.unhealthyThreshold()).map(value => value: primitives.Integer)
    override def timeoutSecondsValue: scala.Option[primitives.Integer] = scala.Option(impl.timeoutSeconds()).map(value => value: primitives.Integer)
    override def intervalSecondsValue: scala.Option[primitives.Integer] = scala.Option(impl.intervalSeconds()).map(value => value: primitives.Integer)
    override def pathValue: scala.Option[String] = scala.Option(impl.path()).map(value => value: String)
    override def successCodesValue: scala.Option[String] = scala.Option(impl.successCodes()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceHealthCheckConfig): ReadOnly = new Wrapper(impl)
}