package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerServiceDeploymentRequest(containers: scala.Option[Map[primitives.ContainerName, Container]] = None, publicEndpoint: scala.Option[EndpointRequest] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest = {
    import ContainerServiceDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest.builder().optionallyWith(containers.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.buildAwsValue()
    }).asJava))(_.containers).optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(_.publicEndpoint).build()
  }
  def asReadOnly: ContainerServiceDeploymentRequest.ReadOnly = ContainerServiceDeploymentRequest.wrap(buildAwsValue())
}
object ContainerServiceDeploymentRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerServiceDeploymentRequest = ContainerServiceDeploymentRequest(containersValue.map(value => value.map({
      case (key, value) =>
        key -> value.editable
    })), publicEndpointValue.map(value => value.editable))
    def containersValue: scala.Option[Map[primitives.ContainerName, Container.ReadOnly]]
    def publicEndpointValue: scala.Option[EndpointRequest.ReadOnly]
    def containers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.ContainerName, Container.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containers", containersValue)
    def publicEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EndpointRequest.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicEndpoint", publicEndpointValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest) extends ContainerServiceDeploymentRequest.ReadOnly {
    override def containersValue: scala.Option[Map[primitives.ContainerName, Container.ReadOnly]] = scala.Option(impl.containers()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.ContainerName) -> Container.wrap(value)
    }).toMap)
    override def publicEndpointValue: scala.Option[EndpointRequest.ReadOnly] = scala.Option(impl.publicEndpoint()).map(value => EndpointRequest.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentRequest): ReadOnly = new Wrapper(impl)
}