package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CacheSettings(defaultTTL: scala.Option[Long] = None, minimumTTL: scala.Option[Long] = None, maximumTTL: scala.Option[Long] = None, allowedHTTPMethods: scala.Option[primitives.NonEmptyString] = None, cachedHTTPMethods: scala.Option[primitives.NonEmptyString] = None, forwardedCookies: scala.Option[CookieObject] = None, forwardedHeaders: scala.Option[HeaderObject] = None, forwardedQueryStrings: scala.Option[QueryStringObject] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CacheSettings = {
    import CacheSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheSettings.builder().optionallyWith(defaultTTL.map(value => value: java.lang.Long))(_.defaultTTL).optionallyWith(minimumTTL.map(value => value: java.lang.Long))(_.minimumTTL).optionallyWith(maximumTTL.map(value => value: java.lang.Long))(_.maximumTTL).optionallyWith(allowedHTTPMethods.map(value => value: java.lang.String))(_.allowedHTTPMethods).optionallyWith(cachedHTTPMethods.map(value => value: java.lang.String))(_.cachedHTTPMethods).optionallyWith(forwardedCookies.map(value => value.buildAwsValue()))(_.forwardedCookies).optionallyWith(forwardedHeaders.map(value => value.buildAwsValue()))(_.forwardedHeaders).optionallyWith(forwardedQueryStrings.map(value => value.buildAwsValue()))(_.forwardedQueryStrings).build()
  }
  def asReadOnly: CacheSettings.ReadOnly = CacheSettings.wrap(buildAwsValue())
}
object CacheSettings {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CacheSettings] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CacheSettings = CacheSettings(defaultTTLValue.map(value => value), minimumTTLValue.map(value => value), maximumTTLValue.map(value => value), allowedHTTPMethodsValue.map(value => value), cachedHTTPMethodsValue.map(value => value), forwardedCookiesValue.map(value => value.editable), forwardedHeadersValue.map(value => value.editable), forwardedQueryStringsValue.map(value => value.editable))
    def defaultTTLValue: scala.Option[Long]
    def minimumTTLValue: scala.Option[Long]
    def maximumTTLValue: scala.Option[Long]
    def allowedHTTPMethodsValue: scala.Option[primitives.NonEmptyString]
    def cachedHTTPMethodsValue: scala.Option[primitives.NonEmptyString]
    def forwardedCookiesValue: scala.Option[CookieObject.ReadOnly]
    def forwardedHeadersValue: scala.Option[HeaderObject.ReadOnly]
    def forwardedQueryStringsValue: scala.Option[QueryStringObject.ReadOnly]
    def defaultTTL: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultTTL", defaultTTLValue)
    def minimumTTL: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumTTL", minimumTTLValue)
    def maximumTTL: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maximumTTL", maximumTTLValue)
    def allowedHTTPMethods: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedHTTPMethods", allowedHTTPMethodsValue)
    def cachedHTTPMethods: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cachedHTTPMethods", cachedHTTPMethodsValue)
    def forwardedCookies: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CookieObject.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forwardedCookies", forwardedCookiesValue)
    def forwardedHeaders: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, HeaderObject.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forwardedHeaders", forwardedHeadersValue)
    def forwardedQueryStrings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, QueryStringObject.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("forwardedQueryStrings", forwardedQueryStringsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CacheSettings) extends CacheSettings.ReadOnly {
    override def defaultTTLValue: scala.Option[Long] = scala.Option(impl.defaultTTL()).map(value => value: Long)
    override def minimumTTLValue: scala.Option[Long] = scala.Option(impl.minimumTTL()).map(value => value: Long)
    override def maximumTTLValue: scala.Option[Long] = scala.Option(impl.maximumTTL()).map(value => value: Long)
    override def allowedHTTPMethodsValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.allowedHTTPMethods()).map(value => value: primitives.NonEmptyString)
    override def cachedHTTPMethodsValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.cachedHTTPMethods()).map(value => value: primitives.NonEmptyString)
    override def forwardedCookiesValue: scala.Option[CookieObject.ReadOnly] = scala.Option(impl.forwardedCookies()).map(value => CookieObject.wrap(value))
    override def forwardedHeadersValue: scala.Option[HeaderObject.ReadOnly] = scala.Option(impl.forwardedHeaders()).map(value => HeaderObject.wrap(value))
    override def forwardedQueryStringsValue: scala.Option[QueryStringObject.ReadOnly] = scala.Option(impl.forwardedQueryStrings()).map(value => QueryStringObject.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CacheSettings): ReadOnly = new Wrapper(impl)
}