package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait BlueprintType { def unwrap: software.amazon.awssdk.services.lightsail.model.BlueprintType }
object BlueprintType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.BlueprintType): BlueprintType = value match {
    case software.amazon.awssdk.services.lightsail.model.BlueprintType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.BlueprintType.OS =>
      val r = os
      r
    case software.amazon.awssdk.services.lightsail.model.BlueprintType.APP =>
      val r = app
      r
  }
  case object unknownToSdkVersion extends BlueprintType { override def unwrap: software.amazon.awssdk.services.lightsail.model.BlueprintType = software.amazon.awssdk.services.lightsail.model.BlueprintType.UNKNOWN_TO_SDK_VERSION }
  case object os extends BlueprintType { override def unwrap: software.amazon.awssdk.services.lightsail.model.BlueprintType = software.amazon.awssdk.services.lightsail.model.BlueprintType.OS }
  case object app extends BlueprintType { override def unwrap: software.amazon.awssdk.services.lightsail.model.BlueprintType = software.amazon.awssdk.services.lightsail.model.BlueprintType.APP }
}