package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateDomainEntryRequest(domainName: primitives.DomainName, domainEntry: DomainEntry) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest = {
    import UpdateDomainEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest.builder().domainName(domainName: java.lang.String).domainEntry(domainEntry.buildAwsValue()).build()
  }
  def asReadOnly: UpdateDomainEntryRequest.ReadOnly = UpdateDomainEntryRequest.wrap(buildAwsValue())
}
object UpdateDomainEntryRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateDomainEntryRequest = UpdateDomainEntryRequest(domainNameValue, domainEntryValue.editable)
    def domainNameValue: primitives.DomainName
    def domainEntryValue: DomainEntry.ReadOnly
    def domainName: ZIO[Any, Nothing, primitives.DomainName] = ZIO.succeed(domainNameValue)
    def domainEntry: ZIO[Any, Nothing, DomainEntry.ReadOnly] = ZIO.succeed(domainEntryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest) extends UpdateDomainEntryRequest.ReadOnly {
    override def domainNameValue: primitives.DomainName = impl.domainName(): primitives.DomainName
    override def domainEntryValue: DomainEntry.ReadOnly = DomainEntry.wrap(impl.domainEntry())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateDomainEntryRequest): ReadOnly = new Wrapper(impl)
}