package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SetIpAddressTypeRequest(resourceType: ResourceType, resourceName: primitives.ResourceName, ipAddressType: IpAddressType) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest = {
    import SetIpAddressTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest.builder().resourceType(resourceType.unwrap).resourceName(resourceName: java.lang.String).ipAddressType(ipAddressType.unwrap).build()
  }
  def asReadOnly: SetIpAddressTypeRequest.ReadOnly = SetIpAddressTypeRequest.wrap(buildAwsValue())
}
object SetIpAddressTypeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SetIpAddressTypeRequest = SetIpAddressTypeRequest(resourceTypeValue, resourceNameValue, ipAddressTypeValue)
    def resourceTypeValue: ResourceType
    def resourceNameValue: primitives.ResourceName
    def ipAddressTypeValue: IpAddressType
    def resourceType: ZIO[Any, Nothing, ResourceType] = ZIO.succeed(resourceTypeValue)
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
    def ipAddressType: ZIO[Any, Nothing, IpAddressType] = ZIO.succeed(ipAddressTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest) extends SetIpAddressTypeRequest.ReadOnly {
    override def resourceTypeValue: ResourceType = ResourceType.wrap(impl.resourceType())
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
    override def ipAddressTypeValue: IpAddressType = IpAddressType.wrap(impl.ipAddressType())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.SetIpAddressTypeRequest): ReadOnly = new Wrapper(impl)
}