package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResourceLocation(availabilityZone: scala.Option[String] = None, regionName: scala.Option[RegionName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ResourceLocation = {
    import ResourceLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceLocation.builder().optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(regionName.map(value => value.unwrap))(_.regionName).build()
  }
  def asReadOnly: ResourceLocation.ReadOnly = ResourceLocation.wrap(buildAwsValue())
}
object ResourceLocation {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ResourceLocation] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResourceLocation = ResourceLocation(availabilityZoneValue.map(value => value), regionNameValue.map(value => value))
    def availabilityZoneValue: scala.Option[String]
    def regionNameValue: scala.Option[RegionName]
    def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
    def regionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RegionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("regionName", regionNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation) extends ResourceLocation.ReadOnly {
    override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
    override def regionNameValue: scala.Option[RegionName] = scala.Option(impl.regionName()).map(value => RegionName.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ResourceLocation): ReadOnly = new Wrapper(impl)
}