package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait MetricName { def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName }
object MetricName {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.MetricName): MetricName = value match {
    case software.amazon.awssdk.services.lightsail.model.MetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.CPU_UTILIZATION =>
      val r = CPUUtilization
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_IN =>
      val r = NetworkIn
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_OUT =>
      val r = NetworkOut
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.STATUS_CHECK_FAILED =>
      val r = StatusCheckFailed
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.STATUS_CHECK_FAILED_INSTANCE =>
      val r = StatusCheckFailed_Instance
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.STATUS_CHECK_FAILED_SYSTEM =>
      val r = StatusCheckFailed_System
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.CLIENT_TLS_NEGOTIATION_ERROR_COUNT =>
      val r = ClientTLSNegotiationErrorCount
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.HEALTHY_HOST_COUNT =>
      val r = HealthyHostCount
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.UNHEALTHY_HOST_COUNT =>
      val r = UnhealthyHostCount
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_LB_4_XX_COUNT =>
      val r = HTTPCode_LB_4XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_LB_5_XX_COUNT =>
      val r = HTTPCode_LB_5XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_2_XX_COUNT =>
      val r = HTTPCode_Instance_2XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_3_XX_COUNT =>
      val r = HTTPCode_Instance_3XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_4_XX_COUNT =>
      val r = HTTPCode_Instance_4XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_5_XX_COUNT =>
      val r = HTTPCode_Instance_5XX_Count
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.INSTANCE_RESPONSE_TIME =>
      val r = InstanceResponseTime
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.REJECTED_CONNECTION_COUNT =>
      val r = RejectedConnectionCount
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.REQUEST_COUNT =>
      val r = RequestCount
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.DATABASE_CONNECTIONS =>
      val r = DatabaseConnections
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.DISK_QUEUE_DEPTH =>
      val r = DiskQueueDepth
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.FREE_STORAGE_SPACE =>
      val r = FreeStorageSpace
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_RECEIVE_THROUGHPUT =>
      val r = NetworkReceiveThroughput
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_TRANSMIT_THROUGHPUT =>
      val r = NetworkTransmitThroughput
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.BURST_CAPACITY_TIME =>
      val r = BurstCapacityTime
      r
    case software.amazon.awssdk.services.lightsail.model.MetricName.BURST_CAPACITY_PERCENTAGE =>
      val r = BurstCapacityPercentage
      r
  }
  case object unknownToSdkVersion extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.UNKNOWN_TO_SDK_VERSION }
  case object CPUUtilization extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.CPU_UTILIZATION }
  case object NetworkIn extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_IN }
  case object NetworkOut extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_OUT }
  case object StatusCheckFailed extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.STATUS_CHECK_FAILED }
  case object StatusCheckFailed_Instance extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.STATUS_CHECK_FAILED_INSTANCE }
  case object StatusCheckFailed_System extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.STATUS_CHECK_FAILED_SYSTEM }
  case object ClientTLSNegotiationErrorCount extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.CLIENT_TLS_NEGOTIATION_ERROR_COUNT }
  case object HealthyHostCount extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.HEALTHY_HOST_COUNT }
  case object UnhealthyHostCount extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.UNHEALTHY_HOST_COUNT }
  case object HTTPCode_LB_4XX_Count extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_LB_4_XX_COUNT }
  case object HTTPCode_LB_5XX_Count extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_LB_5_XX_COUNT }
  case object HTTPCode_Instance_2XX_Count extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_2_XX_COUNT }
  case object HTTPCode_Instance_3XX_Count extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_3_XX_COUNT }
  case object HTTPCode_Instance_4XX_Count extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_4_XX_COUNT }
  case object HTTPCode_Instance_5XX_Count extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.HTTP_CODE_INSTANCE_5_XX_COUNT }
  case object InstanceResponseTime extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.INSTANCE_RESPONSE_TIME }
  case object RejectedConnectionCount extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.REJECTED_CONNECTION_COUNT }
  case object RequestCount extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.REQUEST_COUNT }
  case object DatabaseConnections extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.DATABASE_CONNECTIONS }
  case object DiskQueueDepth extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.DISK_QUEUE_DEPTH }
  case object FreeStorageSpace extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.FREE_STORAGE_SPACE }
  case object NetworkReceiveThroughput extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_RECEIVE_THROUGHPUT }
  case object NetworkTransmitThroughput extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.NETWORK_TRANSMIT_THROUGHPUT }
  case object BurstCapacityTime extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.BURST_CAPACITY_TIME }
  case object BurstCapacityPercentage extends MetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.MetricName = software.amazon.awssdk.services.lightsail.model.MetricName.BURST_CAPACITY_PERCENTAGE }
}