package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class LoadBalancerTlsCertificateDomainValidationRecord(name: scala.Option[primitives.NonEmptyString] = None, `type`: scala.Option[primitives.NonEmptyString] = None, value: scala.Option[primitives.NonEmptyString] = None, validationStatus: scala.Option[LoadBalancerTlsCertificateDomainStatus] = None, domainName: scala.Option[primitives.DomainName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord = {
    import LoadBalancerTlsCertificateDomainValidationRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`).optionallyWith(value.map(value => value: java.lang.String))(_.value).optionallyWith(validationStatus.map(value => value.unwrap))(_.validationStatus).optionallyWith(domainName.map(value => value: java.lang.String))(_.domainName).build()
  }
  def asReadOnly: LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly = LoadBalancerTlsCertificateDomainValidationRecord.wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDomainValidationRecord {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: LoadBalancerTlsCertificateDomainValidationRecord = LoadBalancerTlsCertificateDomainValidationRecord(nameValue.map(value => value), typeValue.map(value => value), valueValue.map(value => value), validationStatusValue.map(value => value), domainNameValue.map(value => value))
    def nameValue: scala.Option[primitives.NonEmptyString]
    def typeValue: scala.Option[primitives.NonEmptyString]
    def valueValue: scala.Option[primitives.NonEmptyString]
    def validationStatusValue: scala.Option[LoadBalancerTlsCertificateDomainStatus]
    def domainNameValue: scala.Option[primitives.DomainName]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
    def validationStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerTlsCertificateDomainStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validationStatus", validationStatusValue)
    def domainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DomainName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainName", domainNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord) extends LoadBalancerTlsCertificateDomainValidationRecord.ReadOnly {
    override def nameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.name()).map(value => value: primitives.NonEmptyString)
    override def typeValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.`type`()).map(value => value: primitives.NonEmptyString)
    override def valueValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.value()).map(value => value: primitives.NonEmptyString)
    override def validationStatusValue: scala.Option[LoadBalancerTlsCertificateDomainStatus] = scala.Option(impl.validationStatus()).map(value => LoadBalancerTlsCertificateDomainStatus.wrap(value))
    override def domainNameValue: scala.Option[primitives.DomainName] = scala.Option(impl.domainName()).map(value => value: primitives.DomainName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord): ReadOnly = new Wrapper(impl)
}