package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetStaticIpRequest(staticIpName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest = {
    import GetStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest.builder().staticIpName(staticIpName: java.lang.String).build()
  }
  def asReadOnly: GetStaticIpRequest.ReadOnly = GetStaticIpRequest.wrap(buildAwsValue())
}
object GetStaticIpRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetStaticIpRequest = GetStaticIpRequest(staticIpNameValue)
    def staticIpNameValue: primitives.ResourceName
    def staticIpName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(staticIpNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest) extends GetStaticIpRequest.ReadOnly { override def staticIpNameValue: primitives.ResourceName = impl.staticIpName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest): ReadOnly = new Wrapper(impl)
}