package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseLogStreamsRequest(relationalDatabaseName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest = {
    import GetRelationalDatabaseLogStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).build()
  }
  def asReadOnly: GetRelationalDatabaseLogStreamsRequest.ReadOnly = GetRelationalDatabaseLogStreamsRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseLogStreamsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseLogStreamsRequest = GetRelationalDatabaseLogStreamsRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: primitives.ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest) extends GetRelationalDatabaseLogStreamsRequest.ReadOnly { override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsRequest): ReadOnly = new Wrapper(impl)
}