package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceSnapshotResponse(instanceSnapshot: scala.Option[InstanceSnapshot] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse = {
    import GetInstanceSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse.builder().optionallyWith(instanceSnapshot.map(value => value.buildAwsValue()))(_.instanceSnapshot).build()
  }
  def asReadOnly: GetInstanceSnapshotResponse.ReadOnly = GetInstanceSnapshotResponse.wrap(buildAwsValue())
}
object GetInstanceSnapshotResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceSnapshotResponse = GetInstanceSnapshotResponse(instanceSnapshotValue.map(value => value.editable))
    def instanceSnapshotValue: scala.Option[InstanceSnapshot.ReadOnly]
    def instanceSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceSnapshot", instanceSnapshotValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse) extends GetInstanceSnapshotResponse.ReadOnly { override def instanceSnapshotValue: scala.Option[InstanceSnapshot.ReadOnly] = scala.Option(impl.instanceSnapshot()).map(value => InstanceSnapshot.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotResponse): ReadOnly = new Wrapper(impl)
}