package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceAccessDetailsResponse(accessDetails: scala.Option[InstanceAccessDetails] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse = {
    import GetInstanceAccessDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse.builder().optionallyWith(accessDetails.map(value => value.buildAwsValue()))(_.accessDetails).build()
  }
  def asReadOnly: GetInstanceAccessDetailsResponse.ReadOnly = GetInstanceAccessDetailsResponse.wrap(buildAwsValue())
}
object GetInstanceAccessDetailsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceAccessDetailsResponse = GetInstanceAccessDetailsResponse(accessDetailsValue.map(value => value.editable))
    def accessDetailsValue: scala.Option[InstanceAccessDetails.ReadOnly]
    def accessDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceAccessDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessDetails", accessDetailsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse) extends GetInstanceAccessDetailsResponse.ReadOnly { override def accessDetailsValue: scala.Option[InstanceAccessDetails.ReadOnly] = scala.Option(impl.accessDetails()).map(value => InstanceAccessDetails.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceAccessDetailsResponse): ReadOnly = new Wrapper(impl)
}