package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerServiceMetricDataResponse(metricName: scala.Option[ContainerServiceMetricName] = None, metricData: scala.Option[Iterable[MetricDatapoint]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse = {
    import GetContainerServiceMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse.builder().optionallyWith(metricName.map(value => value.unwrap))(_.metricName).optionallyWith(metricData.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.metricData).build()
  }
  def asReadOnly: GetContainerServiceMetricDataResponse.ReadOnly = GetContainerServiceMetricDataResponse.wrap(buildAwsValue())
}
object GetContainerServiceMetricDataResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerServiceMetricDataResponse = GetContainerServiceMetricDataResponse(metricNameValue.map(value => value), metricDataValue.map(value => value.map { item => 
      item.editable
    }))
    def metricNameValue: scala.Option[ContainerServiceMetricName]
    def metricDataValue: scala.Option[List[MetricDatapoint.ReadOnly]]
    def metricName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceMetricName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metricName", metricNameValue)
    def metricData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[MetricDatapoint.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metricData", metricDataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse) extends GetContainerServiceMetricDataResponse.ReadOnly {
    override def metricNameValue: scala.Option[ContainerServiceMetricName] = scala.Option(impl.metricName()).map(value => ContainerServiceMetricName.wrap(value))
    override def metricDataValue: scala.Option[List[MetricDatapoint.ReadOnly]] = scala.Option(impl.metricData()).map(value => value.asScala.map { item => 
      MetricDatapoint.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse): ReadOnly = new Wrapper(impl)
}