package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DetachInstancesFromLoadBalancerRequest(loadBalancerName: primitives.ResourceName, instanceNames: Iterable[primitives.ResourceName]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest = {
    import DetachInstancesFromLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).instanceNames(instanceNames.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: DetachInstancesFromLoadBalancerRequest.ReadOnly = DetachInstancesFromLoadBalancerRequest.wrap(buildAwsValue())
}
object DetachInstancesFromLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DetachInstancesFromLoadBalancerRequest = DetachInstancesFromLoadBalancerRequest(loadBalancerNameValue, instanceNamesValue)
    def loadBalancerNameValue: primitives.ResourceName
    def instanceNamesValue: List[primitives.ResourceName]
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
    def instanceNames: ZIO[Any, Nothing, List[primitives.ResourceName]] = ZIO.succeed(instanceNamesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest) extends DetachInstancesFromLoadBalancerRequest.ReadOnly {
    override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName
    override def instanceNamesValue: List[primitives.ResourceName] = impl.instanceNames().asScala.map { item => 
      item: primitives.ResourceName
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DetachInstancesFromLoadBalancerRequest): ReadOnly = new Wrapper(impl)
}