package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteInstanceSnapshotRequest(instanceSnapshotName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest = {
    import DeleteInstanceSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest.builder().instanceSnapshotName(instanceSnapshotName: java.lang.String).build()
  }
  def asReadOnly: DeleteInstanceSnapshotRequest.ReadOnly = DeleteInstanceSnapshotRequest.wrap(buildAwsValue())
}
object DeleteInstanceSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteInstanceSnapshotRequest = DeleteInstanceSnapshotRequest(instanceSnapshotNameValue)
    def instanceSnapshotNameValue: primitives.ResourceName
    def instanceSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest) extends DeleteInstanceSnapshotRequest.ReadOnly { override def instanceSnapshotNameValue: primitives.ResourceName = impl.instanceSnapshotName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceSnapshotRequest): ReadOnly = new Wrapper(impl)
}