package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDiskFromSnapshotRequest(diskName: primitives.ResourceName, diskSnapshotName: scala.Option[primitives.ResourceName] = None, availabilityZone: primitives.NonEmptyString, sizeInGb: primitives.Integer, tags: scala.Option[Iterable[Tag]] = None, addOns: scala.Option[Iterable[AddOnRequest]] = None, sourceDiskName: scala.Option[String] = None, restoreDate: scala.Option[String] = None, useLatestRestorableAutoSnapshot: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest = {
    import CreateDiskFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest.builder().diskName(diskName: java.lang.String).optionallyWith(diskSnapshotName.map(value => value: java.lang.String))(_.diskSnapshotName).availabilityZone(availabilityZone: java.lang.String).sizeInGb(sizeInGb: java.lang.Integer).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(addOns.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.addOns).optionallyWith(sourceDiskName.map(value => value: java.lang.String))(_.sourceDiskName).optionallyWith(restoreDate.map(value => value: java.lang.String))(_.restoreDate).optionallyWith(useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean))(_.useLatestRestorableAutoSnapshot).build()
  }
  def asReadOnly: CreateDiskFromSnapshotRequest.ReadOnly = CreateDiskFromSnapshotRequest.wrap(buildAwsValue())
}
object CreateDiskFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDiskFromSnapshotRequest = CreateDiskFromSnapshotRequest(diskNameValue, diskSnapshotNameValue.map(value => value), availabilityZoneValue, sizeInGbValue, tagsValue.map(value => value.map { item => 
      item.editable
    }), addOnsValue.map(value => value.map { item => 
      item.editable
    }), sourceDiskNameValue.map(value => value), restoreDateValue.map(value => value), useLatestRestorableAutoSnapshotValue.map(value => value))
    def diskNameValue: primitives.ResourceName
    def diskSnapshotNameValue: scala.Option[primitives.ResourceName]
    def availabilityZoneValue: primitives.NonEmptyString
    def sizeInGbValue: primitives.Integer
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]]
    def sourceDiskNameValue: scala.Option[String]
    def restoreDateValue: scala.Option[String]
    def useLatestRestorableAutoSnapshotValue: scala.Option[Boolean]
    def diskName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskNameValue)
    def diskSnapshotName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskSnapshotName", diskSnapshotNameValue)
    def availabilityZone: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(availabilityZoneValue)
    def sizeInGb: ZIO[Any, Nothing, primitives.Integer] = ZIO.succeed(sizeInGbValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AddOnRequest.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addOns", addOnsValue)
    def sourceDiskName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceDiskName", sourceDiskNameValue)
    def restoreDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("restoreDate", restoreDateValue)
    def useLatestRestorableAutoSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useLatestRestorableAutoSnapshot", useLatestRestorableAutoSnapshotValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest) extends CreateDiskFromSnapshotRequest.ReadOnly {
    override def diskNameValue: primitives.ResourceName = impl.diskName(): primitives.ResourceName
    override def diskSnapshotNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.diskSnapshotName()).map(value => value: primitives.ResourceName)
    override def availabilityZoneValue: primitives.NonEmptyString = impl.availabilityZone(): primitives.NonEmptyString
    override def sizeInGbValue: primitives.Integer = impl.sizeInGb(): primitives.Integer
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]] = scala.Option(impl.addOns()).map(value => value.asScala.map { item => 
      AddOnRequest.wrap(item)
    }.toList)
    override def sourceDiskNameValue: scala.Option[String] = scala.Option(impl.sourceDiskName()).map(value => value: String)
    override def restoreDateValue: scala.Option[String] = scala.Option(impl.restoreDate()).map(value => value: String)
    override def useLatestRestorableAutoSnapshotValue: scala.Option[Boolean] = scala.Option(impl.useLatestRestorableAutoSnapshot()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateDiskFromSnapshotRequest): ReadOnly = new Wrapper(impl)
}