package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerServiceDeployment(version: scala.Option[primitives.Integer] = None, state: scala.Option[ContainerServiceDeploymentState] = None, containers: scala.Option[Map[primitives.ContainerName, Container]] = None, publicEndpoint: scala.Option[ContainerServiceEndpoint] = None, createdAt: scala.Option[primitives.IsoDate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment = {
    import ContainerServiceDeployment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment.builder().optionallyWith(version.map(value => value: java.lang.Integer))(_.version).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(containers.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.buildAwsValue()
    }).asJava))(_.containers).optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(_.publicEndpoint).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).build()
  }
  def asReadOnly: ContainerServiceDeployment.ReadOnly = ContainerServiceDeployment.wrap(buildAwsValue())
}
object ContainerServiceDeployment {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerServiceDeployment = ContainerServiceDeployment(versionValue.map(value => value), stateValue.map(value => value), containersValue.map(value => value.map({
      case (key, value) =>
        key -> value.editable
    })), publicEndpointValue.map(value => value.editable), createdAtValue.map(value => value))
    def versionValue: scala.Option[primitives.Integer]
    def stateValue: scala.Option[ContainerServiceDeploymentState]
    def containersValue: scala.Option[Map[primitives.ContainerName, Container.ReadOnly]]
    def publicEndpointValue: scala.Option[ContainerServiceEndpoint.ReadOnly]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def version: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("version", versionValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceDeploymentState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def containers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.ContainerName, Container.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containers", containersValue)
    def publicEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceEndpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicEndpoint", publicEndpointValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment) extends ContainerServiceDeployment.ReadOnly {
    override def versionValue: scala.Option[primitives.Integer] = scala.Option(impl.version()).map(value => value: primitives.Integer)
    override def stateValue: scala.Option[ContainerServiceDeploymentState] = scala.Option(impl.state()).map(value => ContainerServiceDeploymentState.wrap(value))
    override def containersValue: scala.Option[Map[primitives.ContainerName, Container.ReadOnly]] = scala.Option(impl.containers()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.ContainerName) -> Container.wrap(value)
    }).toMap)
    override def publicEndpointValue: scala.Option[ContainerServiceEndpoint.ReadOnly] = scala.Option(impl.publicEndpoint()).map(value => ContainerServiceEndpoint.wrap(value))
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeployment): ReadOnly = new Wrapper(impl)
}