package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContactProtocol { def unwrap: software.amazon.awssdk.services.lightsail.model.ContactProtocol }
object ContactProtocol {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ContactProtocol): ContactProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.ContactProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContactProtocol.EMAIL =>
      val r = Email
      r
    case software.amazon.awssdk.services.lightsail.model.ContactProtocol.SMS =>
      val r = SMS
      r
  }
  case object unknownToSdkVersion extends ContactProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactProtocol = software.amazon.awssdk.services.lightsail.model.ContactProtocol.UNKNOWN_TO_SDK_VERSION }
  case object Email extends ContactProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactProtocol = software.amazon.awssdk.services.lightsail.model.ContactProtocol.EMAIL }
  case object SMS extends ContactProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactProtocol = software.amazon.awssdk.services.lightsail.model.ContactProtocol.SMS }
}