package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AccessRules(getObject: scala.Option[AccessType] = None, allowPublicOverrides: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AccessRules = {
    import AccessRules.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessRules.builder().optionallyWith(getObject.map(value => value.unwrap))(_.getObject).optionallyWith(allowPublicOverrides.map(value => value: java.lang.Boolean))(_.allowPublicOverrides).build()
  }
  def asReadOnly: AccessRules.ReadOnly = AccessRules.wrap(buildAwsValue())
}
object AccessRules {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AccessRules] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AccessRules = AccessRules(getObjectValue.map(value => value), allowPublicOverridesValue.map(value => value))
    def getObjectValue: scala.Option[AccessType]
    def allowPublicOverridesValue: scala.Option[Boolean]
    def getObject: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccessType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("getObject", getObjectValue)
    def allowPublicOverrides: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowPublicOverrides", allowPublicOverridesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AccessRules) extends AccessRules.ReadOnly {
    override def getObjectValue: scala.Option[AccessType] = scala.Option(impl.getObject()).map(value => AccessType.wrap(value))
    override def allowPublicOverridesValue: scala.Option[Boolean] = scala.Option(impl.allowPublicOverrides()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AccessRules): ReadOnly = new Wrapper(impl)
}