package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait RelationalDatabaseMetricName { def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName }
object RelationalDatabaseMetricName {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName): RelationalDatabaseMetricName = value match {
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.CPU_UTILIZATION =>
      val r = CPUUtilization
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DATABASE_CONNECTIONS =>
      val r = DatabaseConnections
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DISK_QUEUE_DEPTH =>
      val r = DiskQueueDepth
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.FREE_STORAGE_SPACE =>
      val r = FreeStorageSpace
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_RECEIVE_THROUGHPUT =>
      val r = NetworkReceiveThroughput
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_TRANSMIT_THROUGHPUT =>
      val r = NetworkTransmitThroughput
      r
  }
  case object unknownToSdkVersion extends RelationalDatabaseMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.UNKNOWN_TO_SDK_VERSION }
  case object CPUUtilization extends RelationalDatabaseMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.CPU_UTILIZATION }
  case object DatabaseConnections extends RelationalDatabaseMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DATABASE_CONNECTIONS }
  case object DiskQueueDepth extends RelationalDatabaseMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.DISK_QUEUE_DEPTH }
  case object FreeStorageSpace extends RelationalDatabaseMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.FREE_STORAGE_SPACE }
  case object NetworkReceiveThroughput extends RelationalDatabaseMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_RECEIVE_THROUGHPUT }
  case object NetworkTransmitThroughput extends RelationalDatabaseMetricName { override def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName = software.amazon.awssdk.services.lightsail.model.RelationalDatabaseMetricName.NETWORK_TRANSMIT_THROUGHPUT }
}