package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait OriginProtocolPolicyEnum { def unwrap: software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum }
object OriginProtocolPolicyEnum {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum): OriginProtocolPolicyEnum = value match {
    case software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTP_ONLY =>
      val r = `http-only`
      r
    case software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTPS_ONLY =>
      val r = `https-only`
      r
  }
  case object unknownToSdkVersion extends OriginProtocolPolicyEnum { override def unwrap: software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum = software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.UNKNOWN_TO_SDK_VERSION }
  case object `http-only` extends OriginProtocolPolicyEnum { override def unwrap: software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum = software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTP_ONLY }
  case object `https-only` extends OriginProtocolPolicyEnum { override def unwrap: software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum = software.amazon.awssdk.services.lightsail.model.OriginProtocolPolicyEnum.HTTPS_ONLY }
}