package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceStateRequest(instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest = {
    import GetInstanceStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest.builder().instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: GetInstanceStateRequest.ReadOnly = GetInstanceStateRequest.wrap(buildAwsValue())
}
object GetInstanceStateRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceStateRequest = GetInstanceStateRequest(instanceNameValue)
    def instanceNameValue: primitives.ResourceName
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest) extends GetInstanceStateRequest.ReadOnly { override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceStateRequest): ReadOnly = new Wrapper(impl)
}