package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerServicesResponse(containerServices: scala.Option[Iterable[ContainerService]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse = {
    import GetContainerServicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse.builder().optionallyWith(containerServices.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.containerServices).build()
  }
  def asReadOnly: GetContainerServicesResponse.ReadOnly = GetContainerServicesResponse.wrap(buildAwsValue())
}
object GetContainerServicesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerServicesResponse = GetContainerServicesResponse(containerServicesValue.map(value => value.map { item => 
      item.editable
    }))
    def containerServicesValue: scala.Option[List[ContainerService.ReadOnly]]
    def containerServices: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContainerService.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerServices", containerServicesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse) extends GetContainerServicesResponse.ReadOnly {
    override def containerServicesValue: scala.Option[List[ContainerService.ReadOnly]] = scala.Option(impl.containerServices()).map(value => value.asScala.map { item => 
      ContainerService.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesResponse): ReadOnly = new Wrapper(impl)
}