package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBundlesResponse(bundles: scala.Option[Iterable[Bundle]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBundlesResponse = {
    import GetBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBundlesResponse.builder().optionallyWith(bundles.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.bundles).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetBundlesResponse.ReadOnly = GetBundlesResponse.wrap(buildAwsValue())
}
object GetBundlesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBundlesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBundlesResponse = GetBundlesResponse(bundlesValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def bundlesValue: scala.Option[List[Bundle.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def bundles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Bundle.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundles", bundlesValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBundlesResponse) extends GetBundlesResponse.ReadOnly {
    override def bundlesValue: scala.Option[List[Bundle.ReadOnly]] = scala.Option(impl.bundles()).map(value => value.asScala.map { item => 
      Bundle.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBundlesResponse): ReadOnly = new Wrapper(impl)
}