package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EnableAddOnRequest(resourceName: primitives.ResourceName, addOnRequest: AddOnRequest) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest = {
    import EnableAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest.builder().resourceName(resourceName: java.lang.String).addOnRequest(addOnRequest.buildAwsValue()).build()
  }
  def asReadOnly: EnableAddOnRequest.ReadOnly = EnableAddOnRequest.wrap(buildAwsValue())
}
object EnableAddOnRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EnableAddOnRequest = EnableAddOnRequest(resourceNameValue, addOnRequestValue.editable)
    def resourceNameValue: primitives.ResourceName
    def addOnRequestValue: AddOnRequest.ReadOnly
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
    def addOnRequest: ZIO[Any, Nothing, AddOnRequest.ReadOnly] = ZIO.succeed(addOnRequestValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest) extends EnableAddOnRequest.ReadOnly {
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
    override def addOnRequestValue: AddOnRequest.ReadOnly = AddOnRequest.wrap(impl.addOnRequest())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.EnableAddOnRequest): ReadOnly = new Wrapper(impl)
}