package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDiskSnapshotRequest(diskName: scala.Option[primitives.ResourceName] = None, diskSnapshotName: primitives.ResourceName, instanceName: scala.Option[primitives.ResourceName] = None, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest = {
    import CreateDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest.builder().optionallyWith(diskName.map(value => value: java.lang.String))(_.diskName).diskSnapshotName(diskSnapshotName: java.lang.String).optionallyWith(instanceName.map(value => value: java.lang.String))(_.instanceName).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateDiskSnapshotRequest.ReadOnly = CreateDiskSnapshotRequest.wrap(buildAwsValue())
}
object CreateDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDiskSnapshotRequest = CreateDiskSnapshotRequest(diskNameValue.map(value => value), diskSnapshotNameValue, instanceNameValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def diskNameValue: scala.Option[primitives.ResourceName]
    def diskSnapshotNameValue: primitives.ResourceName
    def instanceNameValue: scala.Option[primitives.ResourceName]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def diskName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskName", diskNameValue)
    def diskSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskSnapshotNameValue)
    def instanceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest) extends CreateDiskSnapshotRequest.ReadOnly {
    override def diskNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.diskName()).map(value => value: primitives.ResourceName)
    override def diskSnapshotNameValue: primitives.ResourceName = impl.diskSnapshotName(): primitives.ResourceName
    override def instanceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.instanceName()).map(value => value: primitives.ResourceName)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateDiskSnapshotRequest): ReadOnly = new Wrapper(impl)
}